/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.entity.nonliving.BlazeGuardianShieldEntity;
import net.adventurez.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlazeGuardianEntity
extends Monster {
    private float eyeOffset = 0.5f;
    private int eyeOffsetCooldown;
    private static final EntityDataAccessor<Byte> GUARDIAN_FLAGS = SynchedEntityData.m_135353_(BlazeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Boolean> SHIELD_NORTH = SynchedEntityData.m_135353_(BlazeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHIELD_EAST = SynchedEntityData.m_135353_(BlazeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHIELD_SOUTH = SynchedEntityData.m_135353_(BlazeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHIELD_WEST = SynchedEntityData.m_135353_(BlazeGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isTryingToShockwave = false;
    private final BlazeGuardianShieldEntity shield_north = new BlazeGuardianShieldEntity(EntityInit.BLAZE_GUARDIAN_SHIELD, this, "shield_north");
    private final BlazeGuardianShieldEntity shield_east = new BlazeGuardianShieldEntity(EntityInit.BLAZE_GUARDIAN_SHIELD, this, "shield_east");
    private final BlazeGuardianShieldEntity shield_south = new BlazeGuardianShieldEntity(EntityInit.BLAZE_GUARDIAN_SHIELD, this, "shield_south");
    private final BlazeGuardianShieldEntity shield_west = new BlazeGuardianShieldEntity(EntityInit.BLAZE_GUARDIAN_SHIELD, this, "shield_west");

    public BlazeGuardianEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createBlazeGuardianAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 3.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new ShockWaveGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ShootFireballGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Blaze.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GUARDIAN_FLAGS, (Object)0);
        this.f_19804_.m_135372_(SHIELD_NORTH, (Object)true);
        this.f_19804_.m_135372_(SHIELD_EAST, (Object)true);
        this.f_19804_.m_135372_(SHIELD_SOUTH, (Object)true);
        this.f_19804_.m_135372_(SHIELD_WEST, (Object)true);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("ShieldNorth", this.shield_north.m_6084_());
        tag.m_128379_("ShieldEast", this.shield_east.m_6084_());
        tag.m_128379_("ShieldSouth", this.shield_south.m_6084_());
        tag.m_128379_("ShieldWest", this.shield_west.m_6084_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(SHIELD_NORTH, (Object)tag.m_128471_("ShieldNorth"));
        if (tag.m_128471_("ShieldNorth")) {
            this.m_9236_().m_7967_((Entity)this.shield_north);
        }
        this.f_19804_.m_135381_(SHIELD_EAST, (Object)tag.m_128471_("ShieldEast"));
        if (tag.m_128471_("ShieldEast")) {
            this.m_9236_().m_7967_((Entity)this.shield_east);
        }
        this.f_19804_.m_135381_(SHIELD_SOUTH, (Object)tag.m_128471_("ShieldSouth"));
        if (tag.m_128471_("ShieldSouth")) {
            this.m_9236_().m_7967_((Entity)this.shield_south);
        }
        this.f_19804_.m_135381_(SHIELD_WEST, (Object)tag.m_128471_("ShieldWest"));
        if (tag.m_128471_("ShieldWest")) {
            this.m_9236_().m_7967_((Entity)this.shield_west);
        }
    }

    private void movePart(BlazeGuardianShieldEntity blazeGuardianShieldEntity, double dx, double dy, double dz) {
        blazeGuardianShieldEntity.m_6034_(this.m_20185_() + dx, this.m_20186_() + 0.2 + dy, this.m_20189_() + dz);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_6785_(double distanceSquared) {
        return false;
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_213780_().m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.m_9236_().m_213780_().m_188501_(), this.m_9236_().m_213780_().m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
        } else {
            double f = (double)this.f_19797_ / 6.2831853 + (double)this.f_20883_ / 360.0 * Math.PI * 2.0 - 1.0;
            this.movePart(this.shield_north, Math.cos(f) * 0.9, 0.0, Math.sin(f) * 0.9);
            this.movePart(this.shield_east, Math.cos(f + 1.570796) * 0.9, 0.0, Math.sin(f + 1.570796) * 0.9);
            this.movePart(this.shield_south, Math.cos(f + 3.1415926) * 0.9, 0.0, Math.sin(f + 3.1415926) * 0.9);
            this.movePart(this.shield_west, Math.cos(f + 4.7123889) * 0.9, 0.0, Math.sin(f + 4.7123889) * 0.9);
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    public void m_8024_() {
        LivingEntity livingEntity;
        --this.eyeOffsetCooldown;
        if (this.eyeOffsetCooldown <= 0) {
            this.eyeOffsetCooldown = 100;
            this.eyeOffset = 0.5f + (float)this.m_9236_().m_213780_().m_188583_() * 3.0f;
        }
        if ((livingEntity = this.m_5448_()) != null && livingEntity.m_20188_() > this.m_20188_() + (double)this.eyeOffset && this.m_6779_(livingEntity) && !this.isTryingToShockwave) {
            Vec3 vec3d = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3d.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    public boolean m_6060_() {
        return this.isFireActive();
    }

    private boolean isFireActive() {
        return ((Byte)this.f_19804_.m_135370_(GUARDIAN_FLAGS) & 1) != 0;
    }

    private void setFireActive(boolean fireActive) {
        byte b = (Byte)this.f_19804_.m_135370_(GUARDIAN_FLAGS);
        b = fireActive ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.f_19804_.m_135381_(GUARDIAN_FLAGS, (Object)b);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_269533_(DamageTypeTags.f_268738_) && this.m_21223_() < this.m_21233_() / 2.0f) {
            amount *= 0.5f;
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_()) {
            if (!this.shield_north.m_213877_()) {
                this.shield_north.m_146870_();
            }
            if (!this.shield_east.m_213877_()) {
                this.shield_east.m_146870_();
            }
            if (!this.shield_south.m_213877_()) {
                this.shield_south.m_146870_();
            }
            if (!this.shield_west.m_213877_()) {
                this.shield_west.m_146870_();
            }
        }
        super.m_6667_(source);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorldAccess, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        if (spawnReason.equals((Object)MobSpawnType.NATURAL) || spawnReason.equals((Object)MobSpawnType.CHUNK_GENERATION)) {
            block0: for (int i = 0; i < serverWorldAccess.m_213780_().m_188503_(3) + 2; ++i) {
                for (int u = 0; u < 10; ++u) {
                    BlockPos pos = new BlockPos((Vec3i)this.m_20183_().m_7918_(this.m_9236_().m_213780_().m_188503_(5), this.m_9236_().m_213780_().m_188503_(5), this.m_9236_().m_213780_().m_188503_(5)));
                    if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)serverWorldAccess.m_6018_(), (BlockPos)pos, (EntityType)EntityType.f_20551_)) continue;
                    Blaze blazeEntity = (Blaze)EntityType.f_20551_.m_20615_((Level)serverWorldAccess.m_6018_());
                    blazeEntity.m_6518_(serverWorldAccess, this.m_9236_().m_6436_(pos), MobSpawnType.NATURAL, null, null);
                    blazeEntity.m_20035_(pos, this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                    serverWorldAccess.m_7967_((Entity)blazeEntity);
                    continue block0;
                }
            }
        }
        if (this.m_9236_() instanceof ServerLevel) {
            serverWorldAccess.m_7967_((Entity)this.shield_north);
            serverWorldAccess.m_7967_((Entity)this.shield_east);
            serverWorldAccess.m_7967_((Entity)this.shield_south);
            serverWorldAccess.m_7967_((Entity)this.shield_west);
            this.f_19804_.m_135381_(SHIELD_NORTH, (Object)true);
            this.f_19804_.m_135381_(SHIELD_EAST, (Object)true);
            this.f_19804_.m_135381_(SHIELD_SOUTH, (Object)true);
            this.f_19804_.m_135381_(SHIELD_WEST, (Object)true);
        }
        return super.m_6518_(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
    }

    public static boolean canSpawn(EntityType<BlazeGuardianEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50134_) || world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50197_)) && BlazeGuardianEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && random.m_188503_(4) == 0 || spawnReason == MobSpawnType.SPAWNER;
    }

    static class ShockWaveGoal
    extends Goal {
        private final BlazeGuardianEntity guardian;
        private int explosionTicker;

        public ShockWaveGoal(BlazeGuardianEntity guardian) {
            this.guardian = guardian;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.guardian.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.guardian.m_6779_(livingEntity) && this.guardian.m_20280_((Entity)livingEntity) < 12.0;
        }

        public void m_8056_() {
            this.explosionTicker = 20;
            this.guardian.setFireActive(true);
            this.guardian.isTryingToShockwave = true;
        }

        public void m_8041_() {
            this.guardian.setFireActive(false);
            this.explosionTicker = 0;
            this.guardian.isTryingToShockwave = false;
        }

        public void m_8037_() {
            --this.explosionTicker;
            LivingEntity livingEntity = this.guardian.m_5448_();
            if (livingEntity != null) {
                if (!this.guardian.m_9236_().m_5776_()) {
                    for (int o = 0; o < 3; ++o) {
                        this.guardian.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.guardian.m_20208_(0.7), this.guardian.m_20187_(), this.guardian.m_20262_(0.7), 0.0, 0.0, 0.0);
                        ((ServerLevel)this.guardian.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.guardian.m_20208_(0.7), this.guardian.m_20187_(), this.guardian.m_20262_(0.7), 0, 0.0, 0.0, 0.0, 0.01);
                    }
                    if (!this.guardian.m_9236_().m_5776_() && this.explosionTicker == 1) {
                        this.guardian.m_9236_().m_255391_((Entity)this.guardian, this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_(), 6.0f, true, Level.ExplosionInteraction.MOB);
                    }
                }
                super.m_8037_();
            }
        }
    }

    static class ShootFireballGoal
    extends Goal {
        private final BlazeGuardianEntity guardian;
        private int fireballsFired;
        private int fireballCooldown;
        private int targetNotVisibleTicks;

        public ShootFireballGoal(BlazeGuardianEntity guardian) {
            this.guardian = guardian;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.guardian.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.guardian.m_6779_(livingEntity);
        }

        public void m_8056_() {
            this.fireballsFired = 0;
        }

        public void m_8041_() {
            this.guardian.setFireActive(false);
            this.targetNotVisibleTicks = 0;
        }

        public void m_8037_() {
            --this.fireballCooldown;
            LivingEntity livingEntity = this.guardian.m_5448_();
            if (livingEntity != null) {
                boolean bl = this.guardian.m_21574_().m_148306_((Entity)livingEntity);
                this.targetNotVisibleTicks = bl ? 0 : ++this.targetNotVisibleTicks;
                double d = this.guardian.m_20280_((Entity)livingEntity);
                if (d < 4.0) {
                    if (!bl) {
                        return;
                    }
                    if (this.fireballCooldown <= 0) {
                        this.fireballCooldown = 20;
                        this.guardian.m_7327_((Entity)livingEntity);
                    }
                    this.guardian.m_21566_().m_6849_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 1.0);
                } else if (d < this.getFollowRange() * this.getFollowRange() && bl) {
                    double e = livingEntity.m_20185_() - this.guardian.m_20185_();
                    double f = livingEntity.m_20227_(0.5) - this.guardian.m_20227_(0.5);
                    double g = livingEntity.m_20189_() - this.guardian.m_20189_();
                    if (this.fireballCooldown <= 0) {
                        ++this.fireballsFired;
                        if (this.fireballsFired == 1) {
                            this.fireballCooldown = 50;
                            this.guardian.setFireActive(true);
                        } else if (this.fireballsFired <= 7) {
                            this.fireballCooldown = 6;
                        } else {
                            this.fireballCooldown = 100;
                            this.fireballsFired = 0;
                            this.guardian.setFireActive(false);
                        }
                        if (this.fireballsFired > 1) {
                            float h = Mth.m_14116_((float)Mth.m_14116_((float)((float)d))) * 0.7f;
                            if (!this.guardian.m_20067_()) {
                                this.guardian.m_9236_().m_5898_((Player)null, 1018, this.guardian.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFireball smallFireballEntity = new SmallFireball(this.guardian.m_9236_(), (LivingEntity)this.guardian, e + this.guardian.m_217043_().m_188583_() * (double)h, f, g + this.guardian.m_217043_().m_188583_() * (double)h);
                                smallFireballEntity.m_20248_(smallFireballEntity.m_20185_(), this.guardian.m_20227_(0.5) + 0.5, smallFireballEntity.m_20189_());
                                this.guardian.m_9236_().m_7967_((Entity)smallFireballEntity);
                            }
                        }
                    }
                    this.guardian.m_21563_().m_24960_((Entity)livingEntity, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.guardian.m_21566_().m_6849_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowRange() {
            return this.guardian.m_21133_(Attributes.f_22277_);
        }
    }
}

